/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.conwip;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.plan.WpaDurationVisitor;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.conwip.ConwipLog;
import cz.insophy.inplan.planning.mokos.conwip.GorComparatorWrapper;
import cz.insophy.inplan.planning.mokos.conwip.GorInternalPropertyComparator;
import cz.insophy.inplan.planning.mokos.conwip.GorPropertyComparator;
import cz.insophy.inplan.planning.mokos.conwip.GorWrapper;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConwipFilter
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(ConwipFilter.class);
    public static final double DEFAULT_HORIZON_DAYS = 7.0;
    public static final double DEFAULT_ESTIMATION_HORIZON_DAYS = 90.0;
    public static final int DEFAULT_REJECTED_LIMIT = 1000;
    private static final boolean DEFAULT_LOGGING_ENABLED = false;
    public static final String AUTH_DATE_PROPERTY = "authorizationDate";
    public static final String AUTH_CONSTRAINT_PROPERTY = "authorizationConstraint";
    private static final boolean DEFAULT_REVERSE_GORS_ORDER = false;
    private Map<Operation, GorWrapper> opGors;
    private WipMonitor wipMonitor;
    private final Set<Operation> outOps;
    private final Set<Operation> outOpsView;
    private final SortedSet<GorWrapper> waitingGors;
    private final Set<GorWrapper> updatedGors;
    private double horizonDays = 7.0;
    private double estimationHorizonDays = 90.0;
    private int rejectedLimit = 1000;
    private boolean loggingEnabled = false;
    private String gorPriorityProperty;
    private boolean reverseGorsOrder = false;
    private boolean canSupplyMoreOps = false;
    private boolean shallSupplyMoreOps = false;
    private long lastMinBound = Long.MIN_VALUE;
    private int changesCnt;

    public ConwipFilter() {
        this.opGors = Maps.newIdentityHashMap();
        this.outOps = Sets.newIdentityHashSet();
        this.outOpsView = Collections.unmodifiableSet(this.outOps);
        this.waitingGors = Sets.newTreeSet();
        this.updatedGors = Sets.newIdentityHashSet();
    }

    public void setHorizonDays(double horizonDays) {
        Preconditions.checkArgument(horizonDays > 1.0E-7, "horizonDays must be greater than 0");
        this.horizonDays = horizonDays;
    }

    public void setEstimationHorizonDays(double estimationHorizonDays) {
        Preconditions.checkArgument(estimationHorizonDays > 1.0E-7, "estimationHorizonDays must be greater than 0");
        this.estimationHorizonDays = estimationHorizonDays;
    }

    public void setRejectedLimit(int rejectedLimit) {
        Preconditions.checkArgument(rejectedLimit > 0, "rejectedLimit must be greater than 0");
        this.rejectedLimit = rejectedLimit;
    }

    public void setGorPriorityProperty(String gorPriorityProperty) {
        this.gorPriorityProperty = gorPriorityProperty;
    }

    public void setReverseGorsOrder(boolean reverseGorsOrder) {
        this.reverseGorsOrder = reverseGorsOrder;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        this.wipMonitor = new WipMonitor(scheduler.getSuperplan(), this.loggingEnabled);
        ShopConfiguration conf = scheduler.getSuperplan().getShopConf();
        Preconditions.checkNotNull(this.gorPriorityProperty, "gorPriorityProperty must be set in ConwipFilter");
        PropertyDefinition pd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, this.gorPriorityProperty);
        GorComparatorWrapper gorComparator = pd != null ? new GorComparatorWrapper(new GorPropertyComparator(pd)) : new GorComparatorWrapper(new GorInternalPropertyComparator(this.gorPriorityProperty));
        Ordering<GorWrapper> gorOrdering = Ordering.from(gorComparator);
        if (this.reverseGorsOrder) {
            gorOrdering = gorOrdering.reverse();
        }
        this.opGors = GorWrapper.buildWrappers(this.getScheduler().getOperations(), gorOrdering);
    }

    @Override
    public void onPlanningFinished() {
        ShopConfiguration conf = this.getScheduler().getSuperplan().getShopConf();
        PropertyDefinition authDatePd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, AUTH_DATE_PROPERTY);
        PropertyDefinition authConstraintPd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, AUTH_CONSTRAINT_PROPERTY);
        Set<GorWrapper> allWrappers = Sets.newIdentityHashSet();
        allWrappers.addAll(this.opGors.values());
        for (GorWrapper gw : allWrappers) {
            Long auth;
            if (authDatePd == null || (auth = (Long)gw.getGor().getProperty(authDatePd)) != null && auth >= gw.getAuthorizationTime()) continue;
            gw.getGor().setProperty(authDatePd, gw.getAuthorizationTime());
            if (authConstraintPd == null) continue;
            if (gw.getLastBlockingIsland() != null) {
                gw.getGor().setProperty(authConstraintPd, gw.getLastBlockingIsland().getName());
                continue;
            }
            gw.getGor().setProperty(authConstraintPd, null);
        }
        this.wipMonitor.finish();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (ops instanceof ChangeTrackingSet) {
            ChangeTrackingSet cts = (ChangeTrackingSet)ops;
            ChangeTrackingSet.Changes changes = cts.getChanges();
            for (Operation remOp : changes.getRemoved()) {
                GorWrapper remGor = this.opGors.get(remOp);
                if (remGor.isRunning()) {
                    this.updatedGors.add(remGor);
                } else {
                    this.waitingGors.remove(remGor);
                }
                ++this.changesCnt;
            }
            for (Operation addOp : changes.getAdded()) {
                GorWrapper addGor = this.opGors.get(addOp);
                if (addGor.isRunning()) {
                    this.updatedGors.add(addGor);
                } else {
                    this.waitingGors.add(addGor);
                }
                ++this.changesCnt;
            }
        } else {
            this.waitingGors.clear();
            for (Operation op : ops) {
                GorWrapper gor = this.opGors.get(op);
                if (gor.isRunning()) {
                    this.updatedGors.add(gor);
                    continue;
                }
                this.waitingGors.add(gor);
            }
            this.changesCnt = 1;
        }
        if (this.changesCnt > 0 || this.shallSupplyMoreOps) {
            int rejectedCnt = 0;
            Iterator iter = this.waitingGors.iterator();
            while (iter.hasNext() && rejectedCnt < this.rejectedLimit) {
                GorWrapper gw = (GorWrapper)iter.next();
                if (this.wipMonitor.isCapacity(gw) || this.shallSupplyMoreOps) {
                    this.wipMonitor.allocateCapacity(gw);
                    gw.setRunning(true);
                    iter.remove();
                    this.updatedGors.add(gw);
                    if (!this.shallSupplyMoreOps) continue;
                    log.debug("One more operation passed through even when its capacity requirements exceed Conwip levels.");
                    this.shallSupplyMoreOps = false;
                    break;
                }
                ++rejectedCnt;
            }
            if (this.shallSupplyMoreOps) {
                log.error("No additional operation found for inclusion in the results of Conwip filter. Ugh.");
                this.canSupplyMoreOps = false;
                this.getScheduler().stopPlanning();
            }
            for (GorWrapper gw : this.updatedGors) {
                this.outOps.removeAll(gw.getOperations());
                this.outOps.addAll(Sets.intersection(gw.getOperations(), ops));
            }
            this.updatedGors.clear();
            this.canSupplyMoreOps = this.outOps.size() != ops.size();
        }
        this.updateBounds();
        this.changesCnt = 0;
        return Tuple.create(this.getDefaultSuccessor(), this.outOpsView);
    }

    private void updateBounds() {
        long minBound = Long.MAX_VALUE;
        for (Operation op : this.outOps) {
            long opBound = op.getBound().getTime();
            if (opBound >= minBound) continue;
            minBound = opBound;
        }
        if (minBound < Long.MAX_VALUE) {
            if (minBound < this.lastMinBound) {
                for (Operation op : this.outOps) {
                    op.updateSimpleBound(this, this.lastMinBound);
                }
            } else {
                this.lastMinBound = minBound;
            }
        }
    }

    @Override
    public boolean onPlanningStopping() {
        this.shallSupplyMoreOps = true;
        return !this.canSupplyMoreOps;
    }

    @Override
    public void onOperationPlanned(Operation op) {
        this.outOps.removeAll(op.getLaOps());
        GorWrapper gorWrapper = this.opGors.get(op);
        GorWrapper.GarWrapper gaw = gorWrapper.markGarAsFinished(op);
        this.wipMonitor.freeCapacity(gaw);
        ++this.changesCnt;
        if (gorWrapper.isFinished()) {
            this.updatedGors.remove(gorWrapper);
        }
    }

    private long getCurrentAuthorizationTime() {
        return this.lastMinBound == Long.MIN_VALUE ? this.getScheduler().getSuperplan().getFixationDate() : this.lastMinBound;
    }

    private class WipMonitor {
        private final ImmutableMap<CapabilityIsland, AtomicLong> normtimeAvailable;
        private final ConwipLog conwipLog;

        public WipMonitor(Superplan superplan, boolean enableLogging) {
            Preconditions.checkNotNull(superplan);
            ImmutableMap.Builder<CapabilityIsland, AtomicLong> ntaBob = ImmutableMap.builder();
            for (CapabilityIsland island : superplan.getShopConf().getIslands()) {
                ntaBob.put(island, new AtomicLong());
            }
            this.normtimeAvailable = ntaBob.build();
            this.estimateAvailableNormtime(superplan);
            this.conwipLog = enableLogging ? new ConwipLog(superplan.getFixationDate(), this.normtimeAvailable) : null;
        }

        private void estimateAvailableNormtime(Superplan superplan) {
            Preconditions.checkState(GeneralizedRequest.isDateValid(superplan.getFixationDate()));
            ShopConfiguration conf = superplan.getShopConf();
            for (Workplace wp : conf.getWorkplaces()) {
                long from = superplan.getFixationDate();
                long to = Math.round((double)from + ConwipFilter.this.estimationHorizonDays * 8.64E7);
                long l = this.calculateAvailableTime(superplan.getPlan().getWorkplaceSchedule(wp), from, to);
                long availableWp = Math.round(ConwipFilter.this.horizonDays * (double)l / ConwipFilter.this.estimationHorizonDays);
                CapabilityIsland island = conf.getIsland(wp);
                AtomicLong availableTotal = this.normtimeAvailable.get(island);
                availableTotal.addAndGet(availableWp);
                availableTotal.compareAndSet(0L, 1L);
            }
        }

        private long calculateAvailableTime(WorkplaceSchedule workplaceSchedule, long from, long to) {
            WpaDurationVisitor.DurationsSummary times = WpaDurationVisitor.calculateDurations(workplaceSchedule, from, to);
            return times.getBubbleTime() + times.getActionTime() + times.getRebuildTime();
        }

        public boolean isCapacity(@Nonnull GorWrapper gorWrapper) {
            boolean res = true;
            for (CapabilityIsland island : gorWrapper.getCapabilityIslands()) {
                if (this.normtimeAvailable.get(island).get() > 0L) continue;
                gorWrapper.setLastBlockingIsland(island);
                this.logBlock(island);
                res = false;
                break;
            }
            return res;
        }

        public void allocateCapacity(@Nonnull GorWrapper gorWrapper) {
            gorWrapper.setAuthorizationTime(ConwipFilter.this.getCurrentAuthorizationTime());
            for (Map.Entry<CapabilityIsland, Long> entry : gorWrapper.getRequestedNormtimes()) {
                CapabilityIsland island = entry.getKey();
                long requestedNormtime = entry.getValue();
                this.normtimeAvailable.get(island).addAndGet(-requestedNormtime);
            }
            this.logAllocation(gorWrapper);
        }

        public void freeCapacity(@Nonnull GorWrapper.GarWrapper gaw) {
            CapabilityIsland island = gaw.getIsland();
            this.normtimeAvailable.get(island).addAndGet(gaw.getRequestedNormtime());
            this.logDeallocation(gaw);
        }

        private void logAllocation(@Nonnull GorWrapper gorw) {
            if (this.conwipLog != null) {
                long t = GeneralizedRequest.isDateValid(ConwipFilter.this.lastMinBound) ? ConwipFilter.this.lastMinBound : ConwipFilter.this.getScheduler().getSuperplan().getFixationDate();
                this.conwipLog.logAllocation(gorw, t);
            }
        }

        private void logDeallocation(@Nonnull GorWrapper.GarWrapper gaw) {
            if (this.conwipLog != null) {
                this.conwipLog.logDeallocation(gaw, ConwipFilter.this.lastMinBound);
            }
        }

        private void logBlock(CapabilityIsland island) {
            if (this.conwipLog != null) {
                this.conwipLog.logBlock(island);
            }
        }

        public void finish() {
            if (this.conwipLog != null) {
                this.conwipLog.write();
            }
        }
    }
}

